#pragma rtGlobals=1		// Use modern global access method.
#include <Percentile and Box Plot>
 

function CAFs(Name)
	string Name
	string aF=ListFolders("TL*")
	variable n=ItemsInList(aF)
	variable i
	DFREF home=getdatafolderDFR()
	for(i=0;i<n;i+=1)
		SetDatafolder $stringfromlist(i,aF)
		wave w=$stringfromlist(0,wavelist("Name",";",""))
		duplicate w, home:temp		
		SetDataFolder Home	
		concatenate/NP=1/KILL {temp}, FCaInColumn
	endfor
end



Function GreyBoxPlot(median, boxTop, boxBottom, whiskerTop, whiskerBottom, XWave, BoxWidth,Check_FirstPlot)
	WAVE/Z median, boxTop, boxBottom, whiskerTop, whiskerBottom
	String XWave		// if null wave, use X scaling, which will be point scaling.
	Variable BoxWidth	// width of the box part of the display, in X units of the X wave.
	Variable Check_FirstPlot

	
	String WName, WCompleteName, medianCompleteName, medianName
	String GraphNote=""
	
	GraphNote += "BOXWIDTH="+num2str(BoxWidth)+";"

	if (!WaveExists(median))
		DoAlert 0, "The median wave does not exists"
		return -1
	endif
	if (!WaveExists(boxTop))
		DoAlert 0,  "The wave giving the tops of the boxes does not exist"
		return -1
	endif
	if (!WaveExists(boxBottom))
		DoAlert 0,  "The wave giving the bottoms of the boxes does not exist"
		return -1
	endif
	
	medianCompleteName = GetWavesDataFolder(median, 2)
	medianName = NameOfWave(median)
	Variable nWavePnts=numpnts(median)
	String boxTopCompleteName = GetWavesDataFolder(boxTop, 2)
	String boxBottomCompleteName = GetWavesDataFolder(boxBottom, 2)
	
	GraphNote += "MEDIANWAVE="+medianCompleteName+";"
	GraphNote += "BOXTOPWAVE="+boxTopCompleteName+";"
	GraphNote += "BOXBOTTOMWAVE="+boxBottomCompleteName+";"
	
	if (!WaveExists(boxTop))
		DoAlert 0,  "The wave specifying the tops of the boxes does not exist"
		return -1
	endif
	if (numpnts(boxTop) != nWavePnts)
		DoAlert 0,  "The wave "+NameOfWave(boxTop)+" does not have the same number of points as "+NameOfWave(median)
		return -1
	endif
		
	if (!WaveExists(boxBottom))
		DoAlert 0,  "The wave specifying the bottoms of the boxes does not exist"
		return -1
	endif
	if (numpnts(boxBottom) != nWavePnts)
		DoAlert 0,  "The wave "+NameOfWave(boxBottom)+" does not have the same number of points as "+NameOfWave(median)
		return -1
	endif
		
	// make a dependency formula for the error bar wave for the box tops
	WName = NameOfWave(boxTop)
	WCompleteName = GetWavesDataFolder(boxTop,2)
	Duplicate/O boxTop, $(WName+"EB")
	Wave boxTopEB = $(WName+"EB")
	SetFormula boxTopEB, WCompleteName+"-"+medianCompleteName
	
	GraphNote += "BOXTOPEBWAVE="+GetWavesDataFolder(boxTopEB,2)+";"
	
	// make a dependency formula for the error bar wave for the box bottoms
	WName = NameOfWave(boxBottom)
	WCompleteName = GetWavesDataFolder(boxBottom,2)
	Duplicate/O boxBottom, $(WName+"EB")
	Wave boxBottomEB = $(WName+"EB")
	SetFormula boxBottomEB, medianCompleteName+"-"+WCompleteName
	
	GraphNote += "BOXBOTTOMEBWAVE="+GetWavesDataFolder(boxBottomEB,2)+";"
	
	if (WaveExists(whiskerTop))
		// make a dependency formula for the error bar wave for the whisker tops
		WName = NameOfWave(whiskerTop)
		WCompleteName = GetWavesDataFolder(whiskerTop,2)
		Duplicate/O whiskerTop, $(WName+"EB")
		Wave whiskerTopEB = $(WName+"EB")
		SetFormula whiskerTopEB, WCompleteName+"-"+boxTopCompleteName
	
		GraphNote += "WHISKERTOPEBWAVE="+GetWavesDataFolder(whiskerTopEB,2)+";"
	else
		GraphNote += "WHISKERTOPEBWAVE=_NONE_;"
	endif
	
	if (WaveExists(whiskerBottom))
		// make a dependency formula for the error bar wave for the whisker bottoms
		WName = NameOfWave(whiskerBottom)
		WCompleteName = GetWavesDataFolder(whiskerBottom,2)
		Duplicate/O whiskerBottom, $(WName+"EB")
		Wave whiskerBottomEB = $(WName+"EB")
		SetFormula whiskerBottomEB, boxBottomCompleteName+"-"+WCompleteName
	
		GraphNote += "WHISKERBOTTOMEBWAVE="+GetWavesDataFolder(whiskerBottomEB,2)+";"
	else
		GraphNote += "WHISKERBOTTOMEBWAVE=_NONE_;"
	endif
	
	// now make the graph
	if (Check_FirstPlot==0)
		Display/B=$Xwave median
		AppendToGraph/B=$Xwave median
		AppendToGraph/B=$Xwave boxTop
		AppendToGraph/B=$Xwave boxBottom
	else
		AppendToGraph/B=$Xwave median
		AppendToGraph/B=$Xwave median
		AppendToGraph/B=$Xwave boxTop
		AppendToGraph/B=$Xwave boxBottom
	endif

	GraphNote += "BOXTRACE="+medianName+"#1;"
	GraphNote += "MEDIANLINETRACE="+medianName+";"

	ModifyGraph mode=2
	ErrorBars/L=0 $(medianName+"#1") BOX,const=(BoxWidth),wave=(boxTopEB,boxBottomEB)
	ErrorBars/T=0 $(medianName) X,const=(BoxWidth)
	if (WaveExists(whiskerBottom))
		ErrorBars/T=0 $(NameOfWave(boxBottom)) Y,wave=(,whiskerBottomEB)
		GraphNote += "WHISKERBOTTOMTRACE="+NameOfWave(boxBottom)+";"
	else
		GraphNote += "WHISKERBOTTOMTRACE=_NONE_;"
	endif
	if (WaveExists(whiskerTop))
		ErrorBars/T=0 $(NameOfWave(boxTop)) Y,wave=(whiskerTopEB,)
		GraphNote += "WHISKERTOPTRACE="+NameOfWave(boxTop)+";"
	else
		GraphNote += "WHISKERTOPTRACE=_NONE_;"
	endif
	if ( WaveExists(XWave) %& (WaveType(XWave) == 0) )
		ModifyGraph toMode=-1
	endif

	return 0
end

Function PlotGroupWhiskerBox(key_Folder,key_Wave,index)
	string key_Folder,key_Wave
	variable index //** 0: without the wave of grand total data,  1: with the wave of grand total data
	
	string aF=ListFolders(key_Folder)
	DFREF home=GetDataFolderDFR()
	string targetwave
	string BoxName,ErrorBarName
	string cmd
	
	variable i

	variable n=ItemsInList(aF)
	
	if(stringmatch(Key_Folder,"")==1)
		n=ItemsInList(wavelist(Key_Wave,";",""))
	endif
	
	for(i=0;i<n;i+=1)
		
		if(stringmatch(Key_Folder,"")!=1)
			SetDataFolder $StringFromList(i,aF)
			targetwave=StringFromList(0,Wavelist(Key_Wave,";",""))
		else
			targetwave=StringFromList(i,Wavelist(Key_Wave,";",""))
		endif
		BoxName= "Box_"+targetwave
		
		fwavepercentile(targetwave,"10;25;50;75;90",BoxName,0,0,0)
		
		BoxName="Box_"+targetwave+"_50"
		wave w50=$BoxName
		BoxName="Box_"+targetwave+"_75"
		wave w75=$BoxName
		BoxName="Box_"+targetwave+"_25"
		wave w25=$BoxName
		BoxName="Box_"+targetwave+"_90"
		wave w90=$BoxName
		BoxName="Box_"+targetwave+"_10"
		wave w10=$BoxName
		

		GreyBoxPlot(w50, w75, w25, w90, w10, targetwave,3,i)

		
		setaxis $targetwave -4,4
		
		switch(index)
			case 1:
				if(i<n-1)
					ModifyGraph freePos($targetwave)={0,Left}, axisEnab($targetwave)={i*(0.94/n),(i+1)*(0.94/n)}
				else
					ModifyGraph freePos($targetwave)={0,Left}, axisEnab($targetwave)={0.95,1.0}
				endif
				ModifyGraph NoLabel($targetwave)=2
				ModifyGraph manTick($targetwave)={-4,8,0,0},manMinor($targetwave)={0,0};DoUpdate
		
				BoxName="Box_"+targetwave+"_25"
				ErrorBarName="Box_"+targetwave+"_10EB"
				sprintf cmd "ErrorBars/T=0.5 %s Y,wave=(,%s)", BoxName,ErrorBarName
				Execute cmd
		
				BoxName="Box_"+targetwave+"_75"
				ErrorBarName="Box_"+targetwave+"_90EB"
				sprintf cmd "ErrorBars/T=0.5 %s Y,wave=(%s,)", BoxName,ErrorBarName
				Execute cmd
			break
			
			case 0:
				
				ModifyGraph freePos($targetwave)={0,Left}, axisEnab($targetwave)={i*(1/n),(i+1)*(1/n)}

				ModifyGraph NoLabel($targetwave)=2
				ModifyGraph manTick($targetwave)={-4,8,0,0},manMinor($targetwave)={0,0};DoUpdate
		
				BoxName="Box_"+targetwave+"_25"
				ErrorBarName="Box_"+targetwave+"_10EB"
				sprintf cmd "ErrorBars/T=0.5 %s Y,wave=(,%s)", BoxName,ErrorBarName
				Execute cmd
		
				BoxName="Box_"+targetwave+"_75"
				ErrorBarName="Box_"+targetwave+"_90EB"
				sprintf cmd "ErrorBars/T=0.5 %s Y,wave=(%s,)", BoxName,ErrorBarName
				Execute cmd
			break
		endswitch

		SetDataFolder Home
				
	endfor


end


function PlotSortGroupWhiskerBox(key_Folder,key_Wave,index)
	string key_Folder,key_Wave
	variable index //** 0: without the wave of grand total data,  1: with the wave of grand total data
	
	string aF=ListFolders(key_Folder)
	DFREF home=GetDataFolderDFR()
	
	variable i

	variable n=ItemsInList(aF)
	

	if(stringmatch(Key_Folder,"")==1)
		n=ItemsInList(wavelist(Key_Wave,";",""))
	endif
	
	make/O/N=(n) SortingOrder,SortingOrderPar
	
	for(i=0;i<n;i+=1)
		if(stringmatch(Key_Folder,"")!=1)
			SetDataFolder $StringFromList(i,aF)
			wave targetwave1=$StringFromList(0,Wavelist(Key_Wave,";",""))
			setdatafolder home			
		else
			wave targetwave1=$StringFromList(i,Wavelist(Key_Wave,";",""))
		endif	
		
		SortingOrderPar[i]=statsmedian(targetwave1)
		SortingOrder[i]=i	
	endfor
	
	Sort/R SortingOrderPar,SortingOrderPar,SortingOrder
		


	string targetwave
	string BoxName,ErrorBarName
	string cmd
	
	
	if(stringmatch(Key_Folder,"")==1)
		n=ItemsInList(wavelist(Key_Wave,";",""))
	endif
	
	for(i=0;i<n;i+=1)
		
		
		if(stringmatch(Key_Folder,"")!=1)
			SetDataFolder $StringFromList(SortingOrder[i],aF)
			targetwave=StringFromList(0,Wavelist(Key_Wave,";",""))
		else
			targetwave=StringFromList(SortingOrder[i],Wavelist(Key_Wave,";",""))
		endif
		BoxName= "Box_"+targetwave
		
		fwavepercentile(targetwave,"10;25;50;75;90",BoxName,0,0,0)
		
		BoxName="Box_"+targetwave+"_50"
		wave w50=$BoxName
		BoxName="Box_"+targetwave+"_75"
		wave w75=$BoxName
		BoxName="Box_"+targetwave+"_25"
		wave w25=$BoxName
		BoxName="Box_"+targetwave+"_90"
		wave w90=$BoxName
		BoxName="Box_"+targetwave+"_10"
		wave w10=$BoxName
		

		GreyBoxPlot(w50, w75, w25, w90, w10, targetwave,3,i)

		
		setaxis $targetwave -4,4
		
		switch(index)
			case 1:
				if(i<n-1)
					ModifyGraph freePos($targetwave)={0,Left}, axisEnab($targetwave)={i*(0.94/n),(i+1)*(0.94/n)}
				else
					ModifyGraph freePos($targetwave)={0,Left}, axisEnab($targetwave)={0.95,1.0}
				endif
				ModifyGraph NoLabel($targetwave)=2
				ModifyGraph manTick($targetwave)={-4,8,0,0},manMinor($targetwave)={0,0};DoUpdate
		
				BoxName="Box_"+targetwave+"_25"
				ErrorBarName="Box_"+targetwave+"_10EB"
				sprintf cmd "ErrorBars/T=0.5 %s Y,wave=(,%s)", BoxName,ErrorBarName
				Execute cmd
		
				BoxName="Box_"+targetwave+"_75"
				ErrorBarName="Box_"+targetwave+"_90EB"
				sprintf cmd "ErrorBars/T=0.5 %s Y,wave=(%s,)", BoxName,ErrorBarName
				Execute cmd
			break
			
			case 0:
				
				ModifyGraph freePos($targetwave)={0,Left}, axisEnab($targetwave)={i*(1/n),(i+1)*(1/n)}

				ModifyGraph NoLabel($targetwave)=2
				ModifyGraph manTick($targetwave)={-4,8,0,0},manMinor($targetwave)={0,0};DoUpdate
		
				BoxName="Box_"+targetwave+"_25"
				ErrorBarName="Box_"+targetwave+"_10EB"
				sprintf cmd "ErrorBars/T=0.5 %s Y,wave=(,%s)", BoxName,ErrorBarName
				Execute cmd
		
				BoxName="Box_"+targetwave+"_75"
				ErrorBarName="Box_"+targetwave+"_90EB"
				sprintf cmd "ErrorBars/T=0.5 %s Y,wave=(%s,)", BoxName,ErrorBarName
				Execute cmd
			break
		endswitch

		SetDataFolder Home
		
	endfor


end

function Plot3WavesBoxPlotBySort(KeyWord,keyColumn,index)
	String KeyWord
	variable KeyColumn,index
	
	string aW=WaveList(KeyWord,";","")
	variable i,j
	String Name
	
	wave tw=$stringfromlist(0,aW)
	variable n
	

	n=ItemsInList(aw)


	
	for(j=0;j<DimSize(tw,1);j+=1)
		Name="Column_"+num2str(j)
		SeqSepWaves(KeyWord,j,Name)
	endfor
	
	make/O/N=(n) SortingOrder,SortingOrderPar
	
	Name="*Column_"+num2str(KeyColumn)+"*"
	string Keyaw=WaveList(Name,";","")
		
	for(i=0;i<ItemsInList(Keyaw);i+=1)
		
		wave targetwave1=$stringfromlist(i,Keyaw)
	
		SortingOrderPar[i]=statsmedian(targetwave1)
		SortingOrder[i]=i	
	endfor
	
	switch(index)
		case 0:	
			Sort/R SortingOrderPar,SortingOrderPar,SortingOrder
			break
		case 1:
			duplicate/R=[DimSize(SortingOrderPar,0)-1,DimSize(SortingOrderPar,0)-1][] SortingOrderPar, SP_temp
			duplicate/R=[DimSize(SortingOrderPar,0)-1,DimSize(SortingOrderPar,0)-1][] SortingOrder, SO_temp
			deletepoints DimSize(SortingOrderPar,0)-1,1,SortingOrderPar
			deletepoints DimSize(SortingOrder,0)-1,1,SortingOrder
			Sort/R SortingOrderPar,SortingOrderPar,SortingOrder
			concatenate/KILL/NP=1 {SP_temp}, SortingOrderPar
			concatenate/KILL/NP=1 {SO_temp}, SortingOrder
			break
	endswitch
	
	n=ItemsInList(Keyaw)
	
	string StrName
		
	for(j=0;j<DimSize(tw,1);j+=1)
		if(j!=KeyColumn)
			Name="*Column_"+num2str(j)+"*"
			StrName="Type_"+num2str(j)
			string/G $StrName=WaveList(Name,";","")
		else
		endif
	endfor
	
	

	string targetwave,typewave
	string BoxName,ErrorBarName
	string cmd	
	string WaveNameList
	variable k=1
	string s2
	
	for(i=0;i<n;i+=1)
		
				
		targetwave=StringFromList(SortingOrder[i],Keyaw)
				
		BoxName= "Box_"+targetwave
		
		fwavepercentile(targetwave,"10;25;50;75;90",BoxName,0,0,0)
		
		BoxName="Box_"+targetwave+"_50"
		wave w50=$BoxName
		SetScale/P x,-6,1,w50
		BoxName="Box_"+targetwave+"_75"
		wave w75=$BoxName
		SetScale/P x,-6,1,w75
		BoxName="Box_"+targetwave+"_25"
		wave w25=$BoxName
		SetScale/P x,-6,1,w25
		BoxName="Box_"+targetwave+"_90"
		wave w90=$BoxName
		BoxName="Box_"+targetwave+"_10"
		wave w10=$BoxName
		

		GreyBoxPlot(w50, w75, w25, w90, w10, targetwave,2,i)
		
		k=1
		
		for(j=0;j<DimSize(tw,1);j+=1)
			
			if(j<KeyColumn)
				s2=stringfromlist(j,StringList("Type_*",";"))			
				SVAR/Z ss=$s2
				typewave =StringFromList(SortingOrder[i],ss)
			elseif(j>KeyColumn)
				s2=stringfromlist(j-1,StringList("Type_*",";"))
				SVAR/Z ss=$s2
				typewave =StringFromList(SortingOrder[i],ss)
			endif
			
			if(j!=KeyColumn)
				BoxName= "Box_"+typewave
		
				fwavepercentile(typewave,"10;25;50;75;90",BoxName,0,0,0)
			
				BoxName="Box_"+typewave+"_50"
				wave w50=$BoxName
				SetScale/P x,(-6+6*k),1,w50
				BoxName="Box_"+typewave+"_75"
				wave w75=$BoxName
				SetScale/P x,(-6+6*k),1,w75
				BoxName="Box_"+typewave+"_25"
				wave w25=$BoxName
				SetScale/P x,(-6+6*k),1,w25
				BoxName="Box_"+typewave+"_90"
				wave w90=$BoxName
				BoxName="Box_"+typewave+"_10"
				wave w10=$BoxName
			
				GreyBoxPlot(w50, w75, w25, w90, w10, targetwave,2,k)
				k=k+1
			endif
		endfor
		
				
		setaxis $targetwave -10,10
		
		switch(index)
			case 1:
				if(i<n-1)
					ModifyGraph freePos($targetwave)={0,Left}, axisEnab($targetwave)={i*(0.94/n),(i+1)*(0.94/n)}
				else
					ModifyGraph freePos($targetwave)={0,Left}, axisEnab($targetwave)={0.95,1.0}
				endif
				ModifyGraph NoLabel($targetwave)=2
				ModifyGraph manTick($targetwave)={-10,20,0,0},manMinor($targetwave)={0,0};DoUpdate
		
				
				for(j=0;j<DimSize(tw,1);j+=1)
			
					if(j<KeyColumn)
						s2=stringfromlist(j,StringList("Type_*",";"))			
						SVAR/Z ss=$s2
						typewave =StringFromList(SortingOrder[i],ss)
					elseif(j>KeyColumn)
						s2=stringfromlist(j-1,StringList("Type_*",";"))
						SVAR/Z ss=$s2
						typewave =StringFromList(SortingOrder[i],ss)
					else
						typewave=targetwave
					endif
								
					BoxName="Box_"+typewave+"_25"
					ErrorBarName="Box_"+typewave+"_10EB"
					sprintf cmd "ErrorBars/T=0.5 %s Y,wave=(,%s)", BoxName,ErrorBarName
					Execute cmd
		
					BoxName="Box_"+typewave+"_75"
					ErrorBarName="Box_"+typewave+"_90EB"
					sprintf cmd "ErrorBars/T=0.5 %s Y,wave=(%s,)", BoxName,ErrorBarName
					Execute cmd		
					
				endfor
								
			break
			
			case 0:
				
				ModifyGraph freePos($targetwave)={0,Left}, axisEnab($targetwave)={i*(1/n),(i+1)*(1/n)}

				ModifyGraph NoLabel($targetwave)=2
				ModifyGraph manTick($targetwave)={-10,20,0,0},manMinor($targetwave)={0,0};DoUpdate
		
//				BoxName="Box_"+targetwave+"_25"
//				ErrorBarName="Box_"+targetwave+"_10EB"
//				sprintf cmd "ErrorBars/T=0.5 %s Y,wave=(,%s)", BoxName,ErrorBarName
//				Execute cmd
//		
//				BoxName="Box_"+targetwave+"_75"
//				ErrorBarName="Box_"+targetwave+"_90EB"
//				sprintf cmd "ErrorBars/T=0.5 %s Y,wave=(%s,)", BoxName,ErrorBarName
//				Execute cmd
				for(j=0;j<DimSize(tw,1);j+=1)
			
					if(j<KeyColumn)
						s2=stringfromlist(j,StringList("Type_*",";"))			
						SVAR/Z ss=$s2
						typewave =StringFromList(SortingOrder[i],ss)
					elseif(j>KeyColumn)
						s2=stringfromlist(j-1,StringList("Type_*",";"))
						SVAR/Z ss=$s2
						typewave =StringFromList(SortingOrder[i],ss)
					else
						typewave=targetwave
					endif
				
				
					BoxName="Box_"+typewave+"_25"
					ErrorBarName="Box_"+typewave+"_10EB"
					sprintf cmd "ErrorBars/T=0.5 %s Y,wave=(,%s)", BoxName,ErrorBarName
					Execute cmd
		
					BoxName="Box_"+typewave+"_75"
					ErrorBarName="Box_"+typewave+"_90EB"
					sprintf cmd "ErrorBars/T=0.5 %s Y,wave=(%s,)", BoxName,ErrorBarName
					Execute cmd		
					
				endfor
			break
		endswitch
		
	endfor
	
end





function SeqSepWaves(Key,Category,Name)
	string Key,Name
	variable Category
	
	string KeyX
	KeyX=Key[0]
	
	string NewWaveName	
	variable i
	variable n=ItemsInList(wavelist(Key,";",""))
	for(i=0;i<n;i+=1)
		wave w=$StringFromList(i,wavelist(Key,";",""))
		NewWaveName=KeyX+"_"+Name+num2str(i)
		SepWaves(NameOfWave(w),Category,NewWaveName)	
	endfor	
	
end


function ChangeColors(Keyword, Color)
	string keyword, Color

	string as=TraceNameList("",";",1)
	variable i
	string cmd
	string s
	string colorcode
	
	strswitch(Color)
		case "Black":
			ColorCode="0,0,0"
		break
		case "Blue":
			ColorCode="0,15872,65280"
		break 
		case "Red":
			ColorCode="65280,0,0"
		break
		case "Green":
			ColorCode="26112,52224,0"
		break
		default:
			DoAlert 0,"This color is not yet prgrammed!. Install yourself, it is a homework!"
			return -1
	endswitch
	
	for(i=0;i<ItemsInList(as);i+=1)
		s = StringFromList(i,as)
		print s
		if(stringmatch(s,keyword)==1)
			sprintf cmd,"ModifyGraph rgb(%s)=(%s)", s, ColorCode
			execute cmd		
		endif
	
	endfor
	
	

end

